<?php

namespace App\Entities\Courses;

use Illuminate\Database\Eloquent\Model;

class Enrolment extends Model 
{

    protected $table = 'enrollments';
    public $timestamps = true;

    public function course()
    {
        return $this->hasOne('Course');
    }

    public function user()
    {
        return $this->belongsTo('App\Entities\Users\User');
    }

    public function plan()
    {
        return $this->hasOne('Plan');
    }

}